/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime;

import filenet.vw.api.VWException;
import filenet.vw.api.VWParticipantHistory;
import filenet.vw.api.VWStepOccurrenceHistory;
import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkWorkObject;
import java.util.Date;

public class VWTrkStepOccurrenceHistory {
    private VWStepOccurrenceHistory m_stepOccurrenceHistory = null;
    private int m_stepId = -1;
    private int m_occurrenceId = -1;
    private Date m_completionDate = null;
    private Date m_dateReceived = null;
    private int m_status = 0;

    public VWTrkStepOccurrenceHistory(VWStepOccurrenceHistory stepOccurrenceHistory) {
        this.m_stepOccurrenceHistory = stepOccurrenceHistory;
        if (stepOccurrenceHistory != null) {
            this.m_occurrenceId = stepOccurrenceHistory.getOccurrenceId();
        }
    }

    public VWTrkStepOccurrenceHistory(int stepId, VWTrkWorkObject vwWorkObject) throws VWException {
        this.m_stepId = stepId;
        this.m_completionDate = null;
        try {
            this.m_dateReceived = vwWorkObject.getDateReceived();
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            throw ex;
        }
        try {
            if (vwWorkObject != null) {
                this.m_occurrenceId = vwWorkObject.getOccurrenceId();
            }
        }
        catch (VWException ex) {
            this.m_occurrenceId = (int)vwWorkObject.getDateReceived().getTime();
        }
    }

    public VWTrkStepOccurrenceHistory(int stepId, VWWorkObject vwWorkObject) throws VWException {
        this.m_stepId = stepId;
        this.m_completionDate = null;
        try {
            if (vwWorkObject != null) {
                this.m_dateReceived = vwWorkObject.getDateReceived();
                try {
                    this.m_occurrenceId = VWTrkWorkObject.getOccurrenceId(vwWorkObject);
                }
                catch (VWException e) {
                    this.m_occurrenceId = (int)this.m_dateReceived.getTime();
                }
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            throw ex;
        }
    }

    public int getOccurrenceId() {
        if (this.m_occurrenceId != -1) {
            return this.m_occurrenceId;
        }
        if (this.m_stepOccurrenceHistory != null) {
            return this.m_stepOccurrenceHistory.getOccurrenceId();
        }
        return -1;
    }

    public void updateStepHistroy(VWTrkWorkObject vwWorkObject) {
        if (vwWorkObject != null) {
            Date dateReceived = null;
            try {
                try {
                    int occurrenceId = vwWorkObject.getOccurrenceId();
                    if (this.m_occurrenceId == -1) {
                        this.m_occurrenceId = occurrenceId;
                    } else if (this.m_occurrenceId != occurrenceId) {
                        return;
                    }
                }
                catch (VWException e) {
                    // empty catch block
                }
                dateReceived = vwWorkObject.getDateReceived();
                if (dateReceived.before(this.m_dateReceived)) {
                    this.m_dateReceived = dateReceived;
                }
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
            }
        }
    }

    public void updateStepHistroy(VWParticipantHistory vwParticipantHistory) {
        Date dateReceived = vwParticipantHistory.getDateReceived();
        if (dateReceived.before(this.m_dateReceived)) {
            this.m_dateReceived = dateReceived;
        }
    }

    public Date getCompletionDate() {
        try {
            if (this.m_stepOccurrenceHistory != null) {
                return this.m_stepOccurrenceHistory.getCompletionDate();
            }
            return this.m_completionDate;
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public Date getDateReceived() {
        try {
            if (this.m_stepOccurrenceHistory != null) {
                return this.m_stepOccurrenceHistory.getDateReceived();
            }
            return this.m_dateReceived;
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public VWStepOccurrenceHistory getVWStepOccurrenceHistory() {
        return this.m_stepOccurrenceHistory;
    }

    public int getStatus() {
        if (this.m_stepOccurrenceHistory != null) {
            try {
                int result = this.m_stepOccurrenceHistory.getStepStatus();
                if (result == 0) {
                    return 2;
                }
                if (result == 1) {
                    return 1;
                }
                if (result == 2) {
                    return 4;
                }
                if (result == 3) {
                    return 12;
                }
                if (result == 4) {
                    return 11;
                }
                return 0;
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
            }
        }
        return 0;
    }

    public void removeReferences() {
        this.m_stepOccurrenceHistory = null;
        this.m_completionDate = null;
        this.m_dateReceived = null;
    }
}

